<?php
/**
 * Migration Script for Bilik Tutor
 */
require_once __DIR__ . '/db.php';

$sql = file_get_contents(__DIR__ . '/sql/create_tutor_tables.sql');

try {
    // MySQL supports multiple statements in exec() but sometimes it's better to split
    $pdo->exec($sql);
    echo "Migration Successful: Bilik Tutor tables created.";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), "already exists") !== false) {
        echo "Migration Note: Tables already exist.";
    } else {
        echo "Migration Failed: " . $e->getMessage();
        exit(1);
    }
}
