<?php
/**
 * Teacher Dashboard Stats Cards Component
 * Display statistics for teacher dashboard
 */

$stats = $stats ?? [];
$studentCount = $stats['students'] ?? 0;
$moduleCount = $stats['modules'] ?? 0;
$classCount = $stats['classes'] ?? 0;
$forumCount = $stats['forums'] ?? 0;
?>
<div class="stats-grid">
    <div class="stat-card success">
        <div class="stat-icon">👨‍🎓</div>
        <div class="stat-content">
            <div class="stat-value"><?php echo $studentCount; ?></div>
            <div class="stat-label">Jumlah Pelajar</div>
        </div>
        <div class="stat-bg-icon">👨‍🎓</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-icon">📚</div>
        <div class="stat-content">
            <div class="stat-value"><?php echo $moduleCount; ?></div>
            <div class="stat-label">Jumlah Modul</div>
        </div>
        <div class="stat-bg-icon">📚</div>
    </div>
    
    <div class="stat-card info">
        <div class="stat-icon">🏫</div>
        <div class="stat-content">
            <div class="stat-value"><?php echo $classCount; ?></div>
            <div class="stat-label">Jumlah Kelas</div>
        </div>
        <div class="stat-bg-icon">🏫</div>
    </div>
    
    <div class="stat-card warning">
        <div class="stat-icon">💬</div>
        <div class="stat-content">
            <div class="stat-value"><?php echo $forumCount; ?></div>
            <div class="stat-label">Jumlah Forum</div>
        </div>
        <div class="stat-bg-icon">💬</div>
    </div>
</div>

