<?php
/**
 * Student Dashboard - Dashboard Tab Component
 * Displays: Welcome banner, stats, today's schedule, recent announcements
 */
?>

<!-- Welcome Banner -->
<div class="welcome-banner animate__animated animate__fadeIn">
    <div class="welcome-emoji"><?php echo htmlspecialchars($studentEmoji); ?></div>
    <div>
        <h1>Hai, <?php echo htmlspecialchars(explode(' ', $studentName)[0]); ?>! 👋</h1>
        <p style="opacity: 0.9; font-size: 1.1rem;">
            Anda ada <span id="classTodayCount" style="font-weight: 700; text-decoration: underline;">0</span> sesi kelas untuk bulan ini. 
            Jom belajar!
        </p>
    </div>
</div>

<!-- Quick Stats Cards -->
<div class="stats-grid">
    <div class="stat-card animate__animated animate__fadeInUp">
        <div class="stat-icon">📚</div>
        <div class="stat-content">
            <div class="stat-value"><?php echo count($studentSubjects); ?></div>
            <div class="stat-label">Jumlah Subjek</div>
        </div>
    </div>
    <div class="stat-card success animate__animated animate__fadeInUp" style="animation-delay: 0.1s;">
        <div class="stat-icon">🎯</div>
        <div class="stat-content">
            <div class="stat-value" style="font-size: 1.5rem;"><?php echo htmlspecialchars($studentLevel); ?></div>
            <div class="stat-label">Tahap Pendidikan</div>
        </div>
    </div>
    <div class="stat-card info animate__animated animate__fadeInUp" style="animation-delay: 0.2s;">
        <div class="stat-icon">📅</div>
        <div class="stat-content">
            <div class="stat-value" id="upcomingClassesCount">0</div>
            <div class="stat-label">Kelas Akan Datang</div>
        </div>
    </div>
    <div class="stat-card warning animate__animated animate__fadeInUp" style="animation-delay: 0.3s;">
        <div class="stat-icon">📖</div>
        <div class="stat-content">
            <div class="stat-value" id="modulesCount">0</div>
            <div class="stat-label">Modul Tersedia</div>
        </div>
    </div>
</div>

<!-- Dashboard Widgets Grid -->
<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 25px; margin-top: 25px;">
    <!-- Today's Schedule Widget -->
    <div class="card animate__animated animate__fadeInLeft">
        <div class="card-header">
            <h3 class="card-title">📅 Jadual Bulan Ini</h3>
            <a href="#" onclick="switchTab(event, 'schedule')" class="btn btn-sm btn-primary">Lihat Semua</a>
        </div>
        <div class="card-body" id="todayScheduleWidget">
            <p class="text-center text-muted">Memuatkan...</p>
        </div>
    </div>
    
    <!-- Recent Announcements Widget -->
    <div class="card animate__animated animate__fadeInRight">
        <div class="card-header">
            <h3 class="card-title">📢 Pengumuman Terkini</h3>
            <a href="#" onclick="switchTab(event, 'announcements')" class="btn btn-sm btn-primary">Lihat Semua</a>
        </div>
        <div class="card-body" id="recentAnnouncementsWidget">
            <p class="text-center text-muted">Memuatkan...</p>
        </div>
    </div>
    
    <!-- My Info Card -->
    <div class="card animate__animated animate__fadeInUp">
        <div class="card-header">
            <h3 class="card-title">📋 Maklumat Saya</h3>
        </div>
        <div class="card-body">
            <div class="info-row">
                <span class="info-label">Nama Penuh</span>
                <span class="info-value"><?php echo htmlspecialchars($studentName); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Umur</span>
                <span class="info-value"><?php echo htmlspecialchars($studentAge); ?> tahun</span>
            </div>
            <div class="info-row">
                <span class="info-label">Tahap</span>
                <span class="info-value"><?php echo htmlspecialchars($studentLevel); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Tahun/Tingkatan</span>
                <span class="info-value"><?php echo htmlspecialchars($studentGrade); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Nama Pengguna</span>
                <span class="info-value">@<?php echo htmlspecialchars($student['username'] ?? '-'); ?></span>
            </div>
        </div>
    </div>
    
    <!-- My Subjects Card -->
    <div class="card animate__animated animate__fadeInUp" style="animation-delay: 0.1s;">
        <div class="card-header">
            <h3 class="card-title">📚 Subjek Saya</h3>
        </div>
        <div class="card-body">
            <?php if (!empty($studentSubjects)): ?>
                <div style="display: flex; flex-wrap: wrap; gap: 10px;">
                    <?php foreach ($studentSubjects as $subject): ?>
                        <span class="subject-tag"><?php echo htmlspecialchars($subject); ?></span>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <p class="text-muted text-center">Tiada subjek didaftarkan</p>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Contacts Card -->
    <div class="card animate__animated animate__fadeInUp" style="animation-delay: 0.2s;">
        <div class="card-header">
            <h3 class="card-title">📞 Kontak Mentor & Guru</h3>
        </div>
        <div class="card-body" id="studentContactsWidget">
            <p class="text-center text-muted">Memuatkan...</p>
            <p class="text-center text-muted" style="margin-top:8px;">info : Jika perlukan bantuan, boleh berhubung dengan Tutor anda.</p>
        </div>
    </div>
</div>
