<?php
/**
 * Admin Dashboard - Tab Pengurusan Guru & Subjek
 * Bahagian I: Senarai Guru
 * Bahagian II: Senarai Subjek
 */
?>
<div id="teachers" class="tab-content">

    <!-- Bahagian I: Senarai Guru -->
    <div class="card mb-4" style="margin-bottom: 30px;">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title">Bahagian I: Senarai Guru/Tutor</h3>
            <button class="btn btn-primary btn-sm" onclick="showAddTeacherModal()">
                <span>➕</span> Tambah Guru
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="teachersTable">
                    <thead>
                        <tr>
                            <th>Nama Guru</th>
                            <th>Username</th>
                            <th>No. Telefon</th>
                             <th>Jenis Sekolah</th>
                              <th>Subjek Diajar</th>
                            <th>Status</th>
                            <th>Tindakan</th>
                        </tr>
                    </thead>
                    <tbody id="teachersList">
                        <tr>
                            <td colspan="5" class="text-center">Memuatkan...</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Bahagian II: Senarai Subjek -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title">Bahagian II: Senarai Subjek</h3>
            <button class="btn btn-primary btn-sm" onclick="showAddSubjectModal()">
                <span>➕</span> Tambah Subjek
            </button>
        </div>
        <div class="card-body">
            <p class="text-muted small mb-3">Senarai subjek yang tersedia untuk pendaftaran guru dan pelajar.</p>
            <div class="table-responsive">
                <table class="table table-hover" id="subjectsTable">
                    <thead>
                        <tr>
                            <th>Nama Subjek</th>
                            <th>Kod</th>
                            <th>Kategori</th>
                            <th>Tahap</th>
                            <th>Tindakan</th>
                        </tr>
                    </thead>
                    <tbody id="subjectsList">
                        <tr>
                            <td colspan="5" class="text-center">Memuatkan...</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Add Subject Modal -->
<div class="modal-overlay" id="addSubjectModal">
    <div class="modal" style="max-width: 500px;">
        <div class="modal-header">
            <h3 class="modal-title">➕ Tambah Subjek Baru</h3>
            <button class="modal-close" onclick="closeModal('addSubjectModal')">×</button>
        </div>
        <div class="modal-body">
            <form id="addSubjectForm" onsubmit="saveSubject(event)">
                <div class="form-group">
                    <label class="form-label">Nama Subjek <span class="required">*</span></label>
                    <input type="text" class="form-control" name="subject_name" required
                        placeholder="Contoh: Matematik Tambahan">
                    <small class="text-muted">Nama penuh subjek yang akan dipaparkan kepada guru dan pelajar.</small>
                </div>
                <div class="form-group">
                    <label class="form-label">Kod Subjek (Optional)</label>
                    <input type="text" class="form-control" name="subject_code" placeholder="Contoh: AMATH">
                    <small class="text-muted">Kod ringkas untuk rujukan dalaman.</small>
                </div>
                <div class="form-group">
                    <label class="form-label">Kategori</label>
                    <select class="form-control form-select" name="category">
                        <option value="Wajib">Wajib</option>
                        <option value="Elektif">Elektif</option>
                    </select>
                    <small class="text-muted">Tentukan sama ada subjek ini teras atau pilihan.</small>
                </div>
                <div class="form-group">
                    <label class="form-label">Tahap Pendidikan</label>
                    <select class="form-control form-select" name="education_level">
                        <option value="">Semua Tahap</option>
                        <option value="Sekolah Rendah">Sekolah Rendah Sahaja</option>
                        <option value="Sekolah Menengah">Sekolah Menengah Sahaja</option>
                    </select>
                    <small class="text-muted">Hadkan subjek ini untuk tahap tertentu jika perlu.</small>
                </div>
                <div style="margin-top: 20px; display: flex; gap: 10px;">
                    <button type="button" class="btn btn-secondary" style="flex: 1;"
                        onclick="closeModal('addSubjectModal')">Batal</button>
                    <button type="submit" class="btn btn-primary" style="flex: 1;">
                        <span class="btn-text">Simpan Subjek</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>