<?php
/**
 * Maintenance Mode Status Check Script
 * Run this script to check the current maintenance mode status
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/db.php';

echo "=== Maintenance Mode Status Check ===\n\n";

try {
    // Check admin table maintenance_mode column
    $stmt = $pdo->prepare("SELECT id, maintenance_mode FROM admin WHERE id = 1");
    $stmt->execute();
    $adminSettings = $stmt->fetch();
    
    if ($adminSettings) {
        echo "Admin Settings:\n";
        echo "  ID: " . $adminSettings['id'] . "\n";
        echo "  Maintenance Mode: " . ($adminSettings['maintenance_mode'] == '1' ? 'ENABLED 🔴' : 'DISABLED 🟢') . "\n";
        echo "  Raw Value: " . $adminSettings['maintenance_mode'] . "\n";
    } else {
        echo "Admin record not found!\n";
    }
    
    echo "\n";
    
    // Check maintenance_logs table
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM maintenance_logs");
    $logCount = $stmt->fetch();
    
    echo "Maintenance Logs:\n";
    echo "  Total Logs: " . $logCount['total'] . "\n";
    
    if ($logCount['total'] > 0) {
        $stmt = $pdo->query("SELECT * FROM maintenance_logs ORDER BY created_at DESC LIMIT 5");
        $logs = $stmt->fetchAll();
        
        echo "\n  Recent Logs:\n";
        foreach ($logs as $log) {
            echo "  - [{$log['created_at']}] {$log['activity']} ({$log['status']})\n";
        }
    }
    
    echo "\n=== Check Complete ===\n";
    
} catch (PDOException $e) {
    echo "Database Error: " . $e->getMessage() . "\n";
}

