<?php
/**
 * Student Dashboard - Forum Tab Component
 * Displays: Forum discussions, search, filter, reply functionality
 */
?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">💬 Forum Perbincangan</h3>
        <div style="display: flex; gap: 10px;">
            <input type="text" class="form-control" id="forumSearch" placeholder="🔍 Cari forum..." oninput="filterForum()" style="width: 250px;">
            <select class="form-control form-select" id="forumSubjectFilter" onchange="filterForum()" style="width: auto;">
                <option value="all">Semua Subjek</option>
                <?php foreach ($studentSubjects as $subject): ?>
                    <option value="<?php echo htmlspecialchars($subject); ?>"><?php echo htmlspecialchars($subject); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <div class="card-body">
        <div id="studentForum" style="display: flex; flex-direction: column; gap: 15px;">
            <p class="text-center text-muted">Memuatkan forum...</p>
        </div>
    </div>
</div>

<!-- Forum Detail Modal -->
<div class="modal-overlay" id="forumDetailModal">
    <div class="modal" style="max-width: 800px;">
        <div class="modal-header">
            <h3 class="modal-title" id="forumDetailTitle">💬 Forum</h3>
            <button class="modal-close" onclick="closeModal('forumDetailModal')">×</button>
        </div>
        <div class="modal-body">
            <!-- Forum Post -->
            <div style="background: #f8f9fa; padding: 20px; border-radius: 10px; margin-bottom: 20px;">
                <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 10px;">
                    <div>
                        <span class="badge badge-primary" id="forumDetailSubject">-</span>
                        <span class="badge badge-secondary" id="forumDetailTeacher">-</span>
                    </div>
                    <small class="text-muted" id="forumDetailDate">-</small>
                </div>
                <div id="forumDetailContent" style="margin-top: 15px; white-space: pre-wrap;">-</div>
                <div id="forumDetailLink" style="margin-top: 10px;"></div>
            </div>
            
            <!-- Replies Section -->
            <div style="margin-bottom: 20px;">
                <h5 style="margin-bottom: 15px;">💬 Balasan (<span id="forumReplyCount">0</span>)</h5>
                <div id="forumRepliesList" style="max-height: 300px; overflow-y: auto;">
                    <p class="text-center text-muted">Tiada balasan</p>
                </div>
            </div>
            
            <!-- Reply Form -->
            <div style="background: #f8f9fa; padding: 15px; border-radius: 10px;">
                <h5 style="margin-bottom: 10px;">✍️ Tambah Balasan</h5>
                <form id="forumReplyForm" onsubmit="submitForumReply(event)">
                    <input type="hidden" id="replyForumId" value="">
                    <div class="form-group">
                        <textarea class="form-control" id="replyContent" rows="3" placeholder="Tulis balasan anda..." required></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary" style="width: 100%;">📤 Hantar Balasan</button>
                </form>
            </div>
            
            <div style="margin-top: 15px;">
                <button type="button" class="btn btn-secondary" style="width: 100%;" onclick="closeModal('forumDetailModal')">Tutup</button>
            </div>
        </div>
    </div>
</div>
