<?php
/**
 * Database Connection Configuration
 * TutorKita System
 */

$host = 'localhost';
$db = 'serebareti_tutorkita';
$user = 'serebareti_TutorKita';
$pass = 'TutorKitaSerebaReti';
$charset = 'utf8mb4';

/**
 * PDO Connection Options
 */
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4"
];

/**
 * Create PDO Connection
 */
try {
    $dsn = "mysql:host=$host;dbname=$db;charset=$charset";
    $pdo = new PDO($dsn, $user, $pass, $options);
    
    // Set timezone
    $pdo->exec("SET time_zone = '+08:00'");
    
} catch (PDOException $e) {
    // Log error (don't show in production)
    error_log("Database Connection Error: " . $e->getMessage());
    
    // Show user-friendly message
    die("Maaf, berlaku masalah sambungan pangkalan data. Sila cuba sebentar lagi.");
}

/**
 * Session Configuration
 */
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/**
 * Base URL Configuration
 */
define('BASE_URL', '/tutorkita');
define('ADMIN_URL', BASE_URL . '/admin');
define('TEACHER_URL', BASE_URL . '/teacher');
define('STUDENT_URL', BASE_URL . '/student');

/**
 * Upload Paths
 */
define('UPLOAD_PATH', __DIR__ . '/assets/uploads');
define('UPLOAD_URL', BASE_URL . '/assets/uploads');

/**
 * Default Profile Emoji Options
 */
define('PROFILE_EMOJIS', [
    '😀', '😎', '😊', '🤓', '🥳',
    '👨‍🏫', '👩‍🏫', '👨‍🎓', '👩‍🎓', '👾'
]);

