<?php
/**
 * Student Dashboard - Schedule Tab Component
 * Displays: Weekly schedule, filter by subject, teacher info
 */
?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">📅 Jadual Waktu Kelas</h3>
        <div style="display: flex; gap: 10px;">
            <select class="form-control form-select" id="scheduleSubjectFilter" onchange="filterSchedule()" style="width: auto;">
                <option value="all">Semua Subjek</option>
                <?php foreach ($studentSubjects as $subject): ?>
                    <option value="<?php echo htmlspecialchars($subject); ?>"><?php echo htmlspecialchars($subject); ?></option>
                <?php endforeach; ?>
            </select>
            <button class="btn btn-primary btn-sm" onclick="loadStudentSchedule()">
                <i class="fas fa-sync"></i> Muat Semula
            </button>
        </div>
    </div>
    <div class="card-body">
        <!-- Schedule Display -->
        <div id="studentSchedule">
            <p class="text-center text-muted">Memuatkan jadual...</p>
        </div>
    </div>
</div>
