<?php
/**
 * Teacher Dashboard Navigation Component
 * Modular navigation sidebar for Teacher Dashboard
 */

$currentTab = $currentTab ?? 'dashboard';
$teacherName = $_SESSION['full_name'] ?? 'Guru';
$teacherEmoji = $_SESSION['profile_emoji'] ?? '👨‍🏫';
$teacherSubjects = json_decode($teacher['subjects'] ?? '[]');
?>
<aside class="sidebar">
    <div class="sidebar-header">
        <div class="sidebar-logo">📚</div>
        <h2 class="sidebar-title">TutorKita</h2>
        <p class="sidebar-subtitle">Panel Guru</p>
    </div>
    
    <nav class="sidebar-nav">
        <a href="#" class="nav-item <?php echo $currentTab === 'dashboard' ? 'active' : ''; ?>" onclick="switchTab('dashboard'); return false;">
            <span class="nav-icon">📊</span> Dashboard
        </a>
        <a href="#" class="nav-item <?php echo $currentTab === 'students' ? 'active' : ''; ?>" onclick="switchTab('students'); return false;">
            <span class="nav-icon">👨‍🎓</span> Pengurusan Pelajar
        </a>
        <a href="#" class="nav-item <?php echo $currentTab === 'modules' ? 'active' : ''; ?>" onclick="switchTab('modules'); return false;">
            <span class="nav-icon">📚</span> Modul Pembelajaran
        </a>
        <a href="#" class="nav-item <?php echo $currentTab === 'schedule' ? 'active' : ''; ?>" onclick="switchTab('schedule'); return false;">
            <span class="nav-icon">📅</span> Jadual Guru
        </a>
        <a href="#" class="nav-item <?php echo $currentTab === 'classrooms' ? 'active' : ''; ?>" onclick="switchTab('classrooms'); return false;">
            <span class="nav-icon">🏫</span> Ruang Kelas Saya
        </a>
        <a href="#" class="nav-item <?php echo $currentTab === 'forum' ? 'active' : ''; ?>" onclick="switchTab('forum'); return false;">
            <span class="nav-icon">💬</span> Forum Perbincangan
        </a>
        <a href="#" class="nav-item <?php echo $currentTab === 'announcements' ? 'active' : ''; ?>" onclick="switchTab('announcements'); return false;">
            <span class="nav-icon">📢</span> Pengumuman
        </a>
        <a href="#" class="nav-item <?php echo $currentTab === 'opr' ? 'active' : ''; ?>" onclick="switchTab('opr'); return false;">
            <span class="nav-icon">📄</span> OPR
        </a>
        <a href="#" class="nav-item <?php echo $currentTab === 'settings' ? 'active' : ''; ?>" onclick="switchTab('settings'); return false;">
            <span class="nav-icon">⚙️</span> Tetapan
        </a>
    </nav>
    
    <div style="padding: 20px; margin-top: auto;">
        <button class="btn btn-secondary" style="width: 100%;" onclick="logout()">
            <span>🚪</span> Log Keluar
        </button>
    </div>
</aside>

