<?php
/**
 * Student Dashboard - Modules Tab Component
 * Displays: Learning modules grid, search, filter by subject
 */
?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">📚 Modul Pembelajaran Saya</h3>
        <div style="display: flex; gap: 10px;">
            <input type="text" class="form-control" id="moduleSearch" placeholder="🔍 Cari modul..." oninput="filterModules()" style="width: 250px;">
            <select class="form-control form-select" id="moduleSubjectFilter" onchange="filterModules()" style="width: auto;">
                <option value="all">Semua Subjek</option>
                <?php foreach ($studentSubjects as $subject): ?>
                    <option value="<?php echo htmlspecialchars($subject); ?>"><?php echo htmlspecialchars($subject); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <div class="card-body">
        <div id="studentModules" class="module-grid">
            <p class="text-center text-muted">Memuatkan modul...</p>
        </div>
    </div>
</div>

<!-- Module Detail Modal -->
<div class="modal-overlay" id="moduleDetailModal">
    <div class="modal" style="max-width: 700px;">
        <div class="modal-header">
            <h3 class="modal-title" id="moduleDetailTitle">📚 Modul</h3>
            <button class="modal-close" onclick="closeModal('moduleDetailModal')">×</button>
        </div>
        <div class="modal-body">
            <div style="margin-bottom: 15px;">
                <span class="badge badge-primary" id="moduleDetailSubject">-</span>
                <span class="badge badge-secondary" id="moduleDetailTeacher">-</span>
            </div>
            
            <div class="form-group">
                <label class="form-label"><strong>Penerangan:</strong></label>
                <p id="moduleDetailDescription" style="background: #f8f9fa; padding: 15px; border-radius: 8px;">-</p>
            </div>
            
            <div class="form-group">
                <label class="form-label"><strong>Kandungan/Nota:</strong></label>
                <div id="moduleDetailContent" style="background: #f8f9fa; padding: 15px; border-radius: 8px; max-height: 300px; overflow-y: auto; white-space: pre-wrap;">-</div>
            </div>
            
            <div class="form-group">
                <label class="form-label"><strong>Pautan & Sumber:</strong></label>
                <div id="moduleDetailLinks"></div>
            </div>
            
            <div style="margin-top: 20px;">
                <button type="button" class="btn btn-secondary" style="width: 100%;" onclick="closeModal('moduleDetailModal')">Tutup</button>
            </div>
        </div>
    </div>
</div>
