<?php
/**
 * Student Dashboard - Announcements Tab Component
 * Displays: All announcements with priority filtering
 */
?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">📢 Pengumuman</h3>
        <div style="display: flex; gap: 10px;">
            <select class="form-control form-select" id="announcementPriorityFilter" onchange="filterAnnouncements()" style="width: auto;">
                <option value="all">Semua Prioriti</option>
                <option value="Urgent">🔴 Urgent</option>
                <option value="Penting">🟡 Penting</option>
                <option value="Normal">⚪ Normal</option>
            </select>
            <select class="form-control form-select" id="announcementSubjectFilter" onchange="filterAnnouncements()" style="width: auto;">
                <option value="all">Semua Subjek</option>
                <?php foreach ($studentSubjects as $subject): ?>
                    <option value="<?php echo htmlspecialchars($subject); ?>"><?php echo htmlspecialchars($subject); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <div class="card-body">
        <div id="studentAnnouncements" style="display: flex; flex-direction: column; gap: 15px;">
            <p class="text-center text-muted">Memuatkan pengumuman...</p>
        </div>
    </div>
</div>

<!-- Announcement Detail Modal -->
<div class="modal-overlay" id="announcementDetailModal">
    <div class="modal" style="max-width: 700px;">
        <div class="modal-header">
            <h3 class="modal-title" id="announcementDetailTitle">📢 Pengumuman</h3>
            <button class="modal-close" onclick="closeModal('announcementDetailModal')">×</button>
        </div>
        <div class="modal-body">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <div>
                    <span class="badge badge-primary" id="announcementDetailCategory">-</span>
                    <span id="announcementDetailPriority">-</span>
                </div>
                <small class="text-muted" id="announcementDetailDate">-</small>
            </div>
            
            <div style="margin-bottom: 15px;">
                <strong>Guru:</strong> <span id="announcementDetailTeacher">-</span>
            </div>
            
            <div class="form-group">
                <div id="announcementDetailContent" style="background: #f8f9fa; padding: 20px; border-radius: 10px; white-space: pre-wrap;">-</div>
            </div>
            
            <div id="announcementDetailAttachment" style="margin-top: 15px;"></div>
            
            <div style="margin-top: 20px;">
                <button type="button" class="btn btn-secondary" style="width: 100%;" onclick="closeModal('announcementDetailModal')">Tutup</button>
            </div>
        </div>
    </div>
</div>
