<?php
require_once __DIR__ . '/db.php';
header('Content-Type: application/json');

try {
    $stmt = $pdo->query("SELECT status, COUNT(*) as count FROM students GROUP BY status");
    $stats = $stmt->fetchAll();

    $stmt = $pdo->query("SELECT id, full_name, status FROM students LIMIT 20");
    $names = $stmt->fetchAll();

    echo json_encode([
        'success' => true,
        'stats' => $stats,
        'sample' => $names
    ]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
