<?php
/**
 * Teacher Dashboard - Tab OPR (One Page Report)
 * Info dan pautan dokumentasi OPR
 */

$oprInfo = null;

// Get OPR info from settings
try {
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'opr_info'");
    $stmt->execute();
    $oprData = $stmt->fetch();
    
    if ($oprData && $oprData['setting_value']) {
        $oprInfo = json_decode($oprData['setting_value'], true);
    }
} catch (Exception $e) {
    $oprInfo = null;
}

$defaultOprInfo = [
    'title' => 'One Page Report (OPR)',
    'description' => 'One Page Report merupakan satu dokumentasi ringkas yang menerangkan penggunaan One Page Report sebagai medium pelaporan utama dalam pengurusan. Dokumentasi ini bertujuan untuk merekod dan memaparkan maklumat penting seperti prestasi pembelajaran, tahap pencapaian pelajar dalam satu paparan yang padat dan mudah difahami. Penggunaan OPR membantu guru memantau perkembangan pelajar secara sistematik, memudahkan komunikasi dengan ibu bapa, serta menyokong perancangan pengajaran yang lebih berfokus dan berasaskan data.',
    'link' => 'https://www.canva.com/design/DAG6y7UmBKU/view'
];

$oprInfo = $oprInfo ?: $defaultOprInfo;
?>
<!-- Tab OPR -->
<div id="opr" class="tab-content <?php echo $currentTab === 'opr' ? 'active' : ''; ?>">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">One Page Report (OPR)</h3>
        </div>
        <div class="card-body">
            <div class="opr-container">
                <div class="opr-header" style="display: flex; align-items: center; gap: 20px; padding: 30px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 15px; color: white; margin-bottom: 30px;">
                    <div style="font-size: 4rem;">📄</div>
                    <div>
                        <h2 style="font-size: 1.8rem; margin-bottom: 5px;"><?php echo htmlspecialchars($oprInfo['title']); ?></h2>
                        <p style="margin: 0; opacity: 0.9;">Dokumentasi & Panduan Penggunaan</p>
                    </div>
                
                <div class="opr-content">
                    <div class="opr-description">
                        <h4 style="color: #667eea; margin-bottom: 15px;">Penerangan</h4>
                        <div class="description-box" style="background: #f5f5f5; padding: 25px; border-radius: 12px; line-height: 1.8; margin-bottom: 30px; border-left: 4px solid #667eea;">
                            <?php echo nl2br(htmlspecialchars($oprInfo['description'])); ?>
                        </div>
                    
                    <div class="opr-link-section">
                        <h4 style="color: #667eea; margin-bottom: 15px;">Dokumen Panduan</h4>
                        <div class="link-card" style="display: flex; align-items: center; gap: 20px; background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%); padding: 25px; border-radius: 12px; margin-bottom: 30px;">
                            <div style="font-size: 3rem;">📘</div>
                            <div style="flex: 1;">
                                <h5 style="margin: 0 0 5px; color: #1e40af;">Dokumentasi Lengkap OPR</h5>
                                <p style="margin: 0; color: #3b82f6; font-size: 0.9rem;">Klik butang di bawah untuk membuka dokumen panduan lengkap One Page Report</p>
                            </div>
                            <a href="<?php echo htmlspecialchars($oprInfo['link']); ?>" target="_blank" class="btn btn-primary" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 12px 25px; border-radius: 8px; text-decoration: none; display: inline-flex; align-items: center; gap: 8px;">
                                Buka Dokumen
                            </a>
                        </div>
                    
                    <div class="opr-benefits">
                        <h4 style="color: #667eea; margin-bottom: 15px;">Faedah Penggunaan OPR</h4>
                        <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(280px, 1fr)); gap: 15px;">
                            <div class="benefit-item" style="display: flex; align-items: center; gap: 12px; padding: 15px; background: white; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); border: 1px solid #e0e0e0;">
                                <span style="font-size: 1.5rem;">📊</span>
                                <span>Paparan padat & mudah difahami</span>
                            </div>
                            <div class="benefit-item" style="display: flex; align-items: center; gap: 12px; padding: 15px; background: white; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); border: 1px solid #e0e0e0;">
                                <span style="font-size: 1.5rem;">📈</span>
                                <span>Pemantauan sistematik</span>
                            </div>
                            <div class="benefit-item" style="display: flex; align-items: center; gap: 12px; padding: 15px; background: white; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); border: 1px solid #e0e0e0;">
                                <span style="font-size: 1.5rem;">👨‍👩‍👧</span>
                                <span>Mudah komunikasi dengan ibu bapa</span>
                            </div>
                            <div class="benefit-item" style="display: flex; align-items: center; gap: 12px; padding: 15px; background: white; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); border: 1px solid #e0e0e0;">
                                <span style="font-size: 1.5rem;">📅</span>
                                <span>Perancangan berasaskan data</span>
                            </div>
                            <div class="benefit-item" style="display: flex; align-items: center; gap: 12px; padding: 15px; background: white; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); border: 1px solid #e0e0e0;">
                                <span style="font-size: 1.5rem;">✅</span>
                                <span>Rekod pembelajaran pelajar</span>
                            </div>
                            <div class="benefit-item" style="display: flex; align-items: center; gap: 12px; padding: 15px; background: white; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); border: 1px solid #e0e0e0;">
                                <span style="font-size: 1.5rem;">🎯</span>
                                <span>Fokus pada pencapaian</span>
                            </div>
                    </div>
            </div>
    </div>
