<?php
// Dashboard Tab Component
// Located at: components/teacher/tab-dashboard.php
?>
<div id="dashboard" class="tab-content active">
    <!-- Animated Welcome Banner -->
    <div class="welcome-banner premium-gradient animate__animated animate__fadeIn"
        style="position: relative; overflow: hidden; padding: 40px; border-radius: var(--radius-xl); margin-bottom: 30px; color: white;">
        <div class="floating-bubbles">
            <div class="bubble" style="width: 40px; height: 40px; left: 10%; bottom: -10%; animation-delay: 0s;"></div>
            <div class="bubble" style="width: 20px; height: 20px; left: 30%; bottom: -10%; animation-delay: 2s;"></div>
            <div class="bubble" style="width: 60px; height: 60px; left: 50%; bottom: -10%; animation-delay: 4s;"></div>
            <div class="bubble" style="width: 30px; height: 30px; left: 70%; bottom: -10%; animation-delay: 1s;"></div>
            <div class="bubble" style="width: 50px; height: 50px; left: 90%; bottom: -10%; animation-delay: 3s;"></div>
        </div>
        <div class="reveal-up" style="position: relative; z-index: 2;">
            <h1 style="color: white; margin-bottom: 15px; font-size: 2.5rem;">Selamat Sejahtera, Guru
                <?php echo htmlspecialchars(explode(' ', $teacherName)[0]); ?>! 🍎
            </h1>
            <p style="font-size: 1.2rem; opacity: 0.9;">Semoga sesi pengajaran anda hari ini membawa impak
                positif kepada semua pelajar!</p>
            <div
                style="margin-top: 25px; font-weight: 500; background: rgba(255,255,255,0.15); padding: 10px 20px; border-radius: 30px; display: inline-block; backdrop-filter: blur(5px);">
                <span id="bannerDay">...</span>, <span id="bannerDate">...</span> | <span
                    id="bannerTime">00:00:00</span>
            </div>
        </div>
    </div>

    <!-- Premium Stats Grid with Animations -->
    <div class="stats-grid"
        style="display: grid; grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 20px; margin-bottom: 30px;">
        <div class="stat-card"
            style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); border-radius: 16px; padding: 25px; color: white; position: relative; overflow: hidden; cursor: pointer; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); animation: fadeInUp 0.6s ease-out 0.1s both;"
            onmouseover="this.style.transform='translateY(-8px) scale(1.02)'; this.style.boxShadow='0 20px 40px rgba(17,153,142,0.4)';"
            onmouseout="this.style.transform='translateY(0) scale(1)'; this.style.boxShadow='0 10px 30px rgba(0,0,0,0.1)';">
            <div style="position: absolute; top: -20px; right: -20px; font-size: 5rem; opacity: 0.2;">👨‍🎓
            </div>
            <div style="position: relative; z-index: 1;">
                <div style="font-size: 3rem; font-weight: 800; text-shadow: 0 2px 10px rgba(0,0,0,0.2);"
                    id="studentCountValue"><?php echo $studentCount; ?></div>
                <div style="font-size: 0.95rem; opacity: 0.95; font-weight: 500;">Pelajar Aktif</div>
            </div>
            <div
                style="position: absolute; bottom: 10px; right: 15px; background: rgba(255,255,255,0.2); padding: 5px 12px; border-radius: 20px; font-size: 0.75rem;">
                📈 Aktif</div>
        </div>

        <div class="stat-card"
            style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 16px; padding: 25px; color: white; position: relative; overflow: hidden; cursor: pointer; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); animation: fadeInUp 0.6s ease-out 0.2s both;"
            onmouseover="this.style.transform='translateY(-8px) scale(1.02)'; this.style.boxShadow='0 20px 40px rgba(102,126,234,0.4)';"
            onmouseout="this.style.transform='translateY(0) scale(1)'; this.style.boxShadow='0 10px 30px rgba(0,0,0,0.1)';">
            <div style="position: absolute; top: -20px; right: -20px; font-size: 5rem; opacity: 0.2;">📚
            </div>
            <div style="position: relative; z-index: 1;">
                <div style="font-size: 3rem; font-weight: 800; text-shadow: 0 2px 10px rgba(0,0,0,0.2);">
                    <?php echo count($teacherSubjects); ?>
                </div>
                <div style="font-size: 0.95rem; opacity: 0.95; font-weight: 500;">Subjek Diajar</div>
            </div>
            <div
                style="position: absolute; bottom: 10px; right: 15px; background: rgba(255,255,255,0.2); padding: 5px 12px; border-radius: 20px; font-size: 0.75rem;">
                📖 Subjek</div>
        </div>

        <div class="stat-card"
            style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); border-radius: 16px; padding: 25px; color: white; position: relative; overflow: hidden; cursor: pointer; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); animation: fadeInUp 0.6s ease-out 0.3s both;"
            onmouseover="this.style.transform='translateY(-8px) scale(1.02)'; this.style.boxShadow='0 20px 40px rgba(240,147,251,0.4)';"
            onmouseout="this.style.transform='translateY(0) scale(1)'; this.style.boxShadow='0 10px 30px rgba(0,0,0,0.1)';">
            <div style="position: absolute; top: -20px; right: -20px; font-size: 5rem; opacity: 0.2;">📅
            </div>
            <div style="position: relative; z-index: 1;">
                <div style="font-size: 3rem; font-weight: 800; text-shadow: 0 2px 10px rgba(0,0,0,0.2);"
                    id="todaySlotsCount">-</div>
                <div style="font-size: 0.95rem; opacity: 0.95; font-weight: 500;">Slot Hari Ini</div>
            </div>
            <div
                style="position: absolute; bottom: 10px; right: 15px; background: rgba(255,255,255,0.2); padding: 5px 12px; border-radius: 20px; font-size: 0.75rem;">
                ⏰ Jadual</div>
        </div>

        <div class="stat-card"
            style="background: linear-gradient(135deg, #FF6B6B 0%, #FFE66D 100%); border-radius: 16px; padding: 25px; color: white; position: relative; overflow: hidden; cursor: pointer; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); animation: fadeInUp 0.6s ease-out 0.4s both;"
            onmouseover="this.style.transform='translateY(-8px) scale(1.02)'; this.style.boxShadow='0 20px 40px rgba(255,107,107,0.4)';"
            onmouseout="this.style.transform='translateY(0) scale(1)'; this.style.boxShadow='0 10px 30px rgba(0,0,0,0.1)';">
            <div style="position: absolute; top: -20px; right: -20px; font-size: 5rem; opacity: 0.2;">⏳
            </div>
            <div style="position: relative; z-index: 1;">
                <div style="font-size: 3rem; font-weight: 800; text-shadow: 0 2px 10px rgba(0,0,0,0.2);"
                    id="dashboardPendingEnrollments">0</div>
                <div style="font-size: 0.95rem; opacity: 0.95; font-weight: 500;">Menunggu Kelulusan</div>
            </div>
            <div
                style="position: absolute; bottom: 10px; right: 15px; background: rgba(255,255,255,0.2); padding: 5px 12px; border-radius: 20px; font-size: 0.75rem;">
                ⚡ Pending</div>
        </div>
    </div>

    <!-- Modern Quick Actions -->
    <div class="card animate__animated animate__fadeInUp"
        style="margin-bottom: 30px; border-radius: var(--radius-xl); overflow: hidden; box-shadow: var(--shadow-lg);">
        <div class="card-header" style="background: var(--gradient-dark); padding: 25px; border: none;">
            <h3 class="card-title"
                style="color: white; margin: 0; font-size: 1.4rem; display: flex; align-items: center; gap: 12px;">
                <span>🚀</span> Tindakan Pantas Guru
            </h3>
        </div>
        <div class="card-body" style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 20px;">
                <button class="btn lift-on-hover premium-gradient-success"
                    onclick="switchTabV2(event, 'student-management'); showAddStudentModalV2();"
                    style="flex-direction: column; padding: 25px; border-radius: 20px; color: white; border: none; gap: 12px;">
                    <span style="font-size: 2.5rem;">👨‍🎓</span>
                    <span style="font-weight: 700;">Tambah Pelajar</span>
                </button>
                <button class="btn lift-on-hover premium-gradient" onclick="switchTabV2(event, 'modules');"
                    style="flex-direction: column; padding: 25px; border-radius: 20px; color: white; border: none; gap: 12px;">
                    <span style="font-size: 2.5rem;">📚</span>
                    <span style="font-weight: 700;">Urus Modul</span>
                </button>
                <button class="btn lift-on-hover premium-gradient-warning" onclick="switchTabV2(event, 'schedule');"
                    style="flex-direction: column; padding: 25px; border-radius: 20px; color: white; border: none; gap: 12px;">
                    <span style="font-size: 2.5rem;">📅</span>
                    <span style="font-weight: 700;">Jadual Waktu</span>
                </button>
                <button class="btn lift-on-hover premium-gradient-info" onclick="switchTabV2(event, 'classrooms');"
                    style="flex-direction: column; padding: 25px; border-radius: 20px; color: white; border: none; gap: 12px;">
                    <span style="font-size: 2.5rem;">🏫</span>
                    <span style="font-weight: 700;">Bilik Darjah</span>
                </button>
                <button class="btn lift-on-hover premium-gradient-danger" onclick="switchTabV2(event, 'announcements');"
                    style="flex-direction: column; padding: 25px; border-radius: 20px; color: white; border: none; gap: 12px;">
                    <span style="font-size: 2.5rem;">📢</span>
                    <span style="font-weight: 700;">Pengumuman</span>
                </button>
            </div>
        </div>
    </div>

    <!-- Info Cards Grid -->
    <div class="dashboard-info-cards"
        style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
        <div class="card"
            style="border-radius: 20px; overflow: hidden; animation: fadeInUp 0.8s ease-out 0.6s both; box-shadow: 0 10px 40px rgba(0,0,0,0.08); border: none;">
            <div style="height: 6px; background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);"></div>
            <div class="card-body" style="padding: 25px;">
                <h4
                    style="margin: 0 0 20px 0; color: #1a1a2e; font-size: 1.1rem; display: flex; align-items: center; gap: 10px;">
                    <span
                        style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 10px; border-radius: 12px; font-size: 1.2rem;">📊</span>
                    Ringkasan Dashboard
                </h4>
                <div style="font-size: 0.95rem; color: #555;">
                    <p
                        style="margin: 12px 0; padding: 12px 15px; background: #f8f9ff; border-radius: 10px; display: flex; align-items: center; gap: 10px;">
                        <span>📅</span> <strong>Hari:</strong> <span id="dashboardDayName"
                            style="margin-left: auto; color: #667eea; font-weight: 600;">-</span>
                    </p>
                    <p
                        style="margin: 12px 0; padding: 12px 15px; background: #f8f9ff; border-radius: 10px; display: flex; align-items: center; gap: 10px;">
                        <span>📆</span> <strong>Tarikh:</strong> <span id="dashboardDate"
                            style="margin-left: auto; color: #667eea; font-weight: 600;">-</span>
                    </p>
                    <p
                        style="margin: 12px 0; padding: 12px 15px; background: #f8f9ff; border-radius: 10px; display: flex; align-items: center; gap: 10px;">
                        <span>⏰</span> <strong>Masa:</strong> <span id="dashboardTime"
                            style="margin-left: auto; color: #667eea; font-weight: 600;">-</span>
                    </p>
                    <p
                        style="margin: 12px 0; padding: 12px 15px; background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%); border-radius: 10px; display: flex; align-items: center; gap: 10px;">
                        <span>👨‍🏫</span> <strong>Guru:</strong> <span
                            style="margin-left: auto; color: #764ba2; font-weight: 600;"><?php echo htmlspecialchars($teacherName); ?></span>
                    </p>
                </div>
            </div>
        </div>

        <div class="card"
            style="border-radius: 20px; overflow: hidden; animation: fadeInUp 0.8s ease-out 0.7s both; box-shadow: 0 10px 40px rgba(0,0,0,0.08); border: none;">
            <div style="height: 6px; background: linear-gradient(90deg, #11998e 0%, #38ef7d 100%);"></div>
            <div class="card-body" style="padding: 25px;">
                <h4
                    style="margin: 0 0 20px 0; color: #1a1a2e; font-size: 1.1rem; display: flex; align-items: center; gap: 10px;">
                    <span
                        style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); padding: 10px; border-radius: 12px; font-size: 1.2rem;">💡</span>
                    Panduan Penggunaan
                </h4>
                <div style="font-size: 0.95rem; color: #555;">
                    <p style="margin: 10px 0; padding: 10px 0; border-bottom: 1px solid #eee;"><span
                            style="color: #11998e;">✅</span> <strong>Pendaftaran:</strong> Luluskan
                        pendaftaran pelajar baru</p>
                    <p style="margin: 10px 0; padding: 10px 0; border-bottom: 1px solid #eee;"><span
                            style="color: #667eea;">📚</span> <strong>Modul:</strong> Cipta nota dan bahan
                        pembelajaran</p>
                    <p style="margin: 10px 0; padding: 10px 0; border-bottom: 1px solid #eee;"><span
                            style="color: #f093fb;">📅</span> <strong>Jadual:</strong> Urus jadual mengajar
                        anda</p>
                    <p style="margin: 10px 0; padding: 10px 0; border-bottom: 1px solid #eee;"><span
                            style="color: #4facfe;">🏫</span> <strong>Kelas Online:</strong> Sesi
                        pembelajaran secara online</p>
                    <p style="margin: 10px 0; padding: 10px 0;"><span style="color: #fa709a;">💬</span>
                        <strong>Forum:</strong> Perbincangan dengan pelajar
                    </p>
                </div>
            </div>
        </div>

        <div class="card"
            style="border-radius: 20px; overflow: hidden; animation: fadeInUp 0.8s ease-out 0.8s both; box-shadow: 0 10px 40px rgba(0,0,0,0.08); border: none;">
            <div style="height: 6px; background: linear-gradient(90deg, #f093fb 0%, #f5576c 100%);"></div>
            <div class="card-body" style="padding: 25px;">
                <h4
                    style="margin: 0 0 20px 0; color: #1a1a2e; font-size: 1.1rem; display: flex; align-items: center; gap: 10px;">
                    <span
                        style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); padding: 10px; border-radius: 12px; font-size: 1.2rem;">📋</span>
                    Menu Pintas
                </h4>
                <div style="display: flex; flex-direction: column; gap: 10px;">
                    <button class="btn"
                        style="text-align: left; background: #f8f9ff; border: 2px solid transparent; padding: 15px; border-radius: 12px; transition: all 0.3s ease; display: flex; align-items: center; gap: 12px;"
                        onclick="switchTabV2(event, 'student-management'); if(window.loadStudentManagementDataV2) loadStudentManagementDataV2();"
                        onmouseover="this.style.borderColor='#667eea'; this.style.background='linear-gradient(135deg, #667eea15 0%, #764ba215 100%)';"
                        onmouseout="this.style.borderColor='transparent'; this.style.background='#f8f9ff';">
                        <span style="font-size: 1.3rem;">👨‍🎓</span>
                        <span style="flex: 1;">Pengurusan Pelajar</span>
                        <span class="badge" id="badge-new-count-dashboard"
                            style="background: linear-gradient(135deg, #FF6B6B 0%, #FFE66D 100%); color: white; padding: 5px 12px; border-radius: 20px; font-weight: 600;">0</span>
                    </button>
                    <button class="btn"
                        style="text-align: left; background: #f8f9ff; border: 2px solid transparent; padding: 15px; border-radius: 12px; transition: all 0.3s ease; display: flex; align-items: center; gap: 12px;"
                        onclick="switchTabV2(event, 'modules'); loadModulesV3();"
                        onmouseover="this.style.borderColor='#11998e'; this.style.background='linear-gradient(135deg, #11998e15 0%, #38ef7d15 100%)';"
                        onmouseout="this.style.borderColor='transparent'; this.style.background='#f8f9ff';">
                        <span style="font-size: 1.3rem;">📚</span>
                        <span>Modul Pembelajaran</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Dashboard Logic - V3

    function loadDashboardV3() {
        console.log('Loading Dashboard V3...');
        loadTodaySlotsV3();
        // loadStudentManagementDataV2 called lazily when switching to student management, 
        // but stats are updated via syncDataOnLoadV2 in main file.
    }

    // Load today's schedule slots
    function loadTodaySlotsV3() {
        var today = new Date().toISOString().split('T')[0];
        fetch(API_PATH + '?action=get_teacher_schedule')
            .then(function (response) { return response.json(); })
            .then(function (result) {
                if (result.success && result.schedules) {
                    // Filter schedules for today
                    var todaySchedules = result.schedules.filter(function (s) {
                        return s.schedule_date === today;
                    });
                    var slotsObj = document.getElementById('todaySlotsCount');
                    if (slotsObj) {
                        var currentSlots = parseInt(slotsObj.textContent) || 0;
                        animateValue('todaySlotsCount', currentSlots, todaySchedules.length, 1000);
                    }
                } else {
                    if (document.getElementById('todaySlotsCount')) {
                        animateValue('todaySlotsCount', 0, 0, 1000);
                        document.getElementById('todaySlotsCount').textContent = '0';
                    }
                }
            })
            .catch(function (err) {
                console.error('Error loading today slots:', err);
                if (document.getElementById('todaySlotsCount')) {
                    document.getElementById('todaySlotsCount').textContent = '-';
                }
            });
    }

    // Utility function if not already globally defined
    if (typeof animateValue !== 'function') {
        function animateValue(id, start, end, duration) {
            var obj = document.getElementById(id);
            if (!obj) return;
            var range = end - start;
            var minTimer = 50;
            var stepTime = Math.abs(Math.floor(duration / range));
            stepTime = Math.max(stepTime, minTimer);
            var startTime = new Date().getTime();
            var endTime = startTime + duration;
            var timer;

            function run() {
                var now = new Date().getTime();
                var remaining = Math.max((endTime - now) / duration, 0);
                var value = Math.round(end - (remaining * range));
                obj.innerHTML = value;
                if (value == end) {
                    clearInterval(timer);
                }
            }

            timer = setInterval(run, stepTime);
            run();
        }
    }
</script>