<?php
/**
 * Student Dashboard - Profile Tab Component
 * Displays: Profile edit form, change password, enrollment status
 */
?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">👤 Profil Saya</h3>
    </div>
    <div class="card-body">
        <!-- Profile Header -->
        <div
            style="display: flex; align-items: center; gap: 20px; margin-bottom: 30px; padding: 20px; background: linear-gradient(135deg, var(--primary-color), var(--primary-dark)); border-radius: 15px; color: white;">
            <div style="font-size: 5rem;"><?php echo htmlspecialchars($studentEmoji); ?></div>
            <div>
                <h3 style="color: white; margin: 0;"><?php echo htmlspecialchars($studentName); ?></h3>
                <p style="margin: 5px 0 0 0; opacity: 0.9;">@<?php echo htmlspecialchars($student['username'] ?? ''); ?>
                </p>
            </div>
        </div>

        <!-- Profile Edit Form -->
        <form id="profileForm" onsubmit="updateProfile(event)">
            <input type="hidden" name="profile_emoji" id="selectedEmoji"
                value="<?php echo htmlspecialchars($studentEmoji); ?>">

            <div class="form-group" style="margin-bottom: 20px;">
                <label class="form-label">Pilih Emoji Profil</label>
                <div class="emoji-picker" id="studentEmojiPicker">
                    <?php
                    $emojis = ['👨‍🎓', '👩‍🎓', '🧑‍🎓', '👦', '👧', '🧒', '😀', '😎', '😊', '🤓', '⭐', '🌟', '💫', '✨', '🎯'];
                    foreach ($emojis as $emoji) {
                        $selected = $studentEmoji === $emoji ? 'selected' : '';
                        echo '<div class="emoji-option ' . $selected . '" data-emoji="' . $emoji . '">' . $emoji . '</div>';
                    }
                    ?>
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">Nama Penuh</label>
                <input type="text" class="form-control" name="full_name"
                    value="<?php echo htmlspecialchars($studentName); ?>" readonly style="background: #f8f9fa;">
                <small class="form-text text-muted">Hubungi guru untuk menukar nama</small>
            </div>

            <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                <div class="form-group">
                    <label class="form-label">Umur</label>
                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($studentAge); ?> tahun"
                        readonly style="background: #f8f9fa;">
                </div>

                <div class="form-group">
                    <label class="form-label">Tahap Pendidikan</label>
                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($studentLevel); ?>"
                        readonly style="background: #f8f9fa;">
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">Nombor Telefon</label>
                <input type="tel" class="form-control" name="phone"
                    value="<?php echo htmlspecialchars($studentPhone); ?>" required>
            </div>

            <div class="form-group">
                <label class="form-label">Nama Penjaga</label>
                <input type="text" class="form-control" value="<?php echo htmlspecialchars($studentParent); ?>" readonly
                    style="background: #f8f9fa;">
                <small class="form-text text-muted">Hubungi guru untuk menukar nama penjaga</small>
            </div>

            <button type="submit" class="btn btn-primary" style="width: 100%; margin-top: 10px;">
                <i class="fas fa-save"></i> Simpan Perubahan
            </button>
        </form>
    </div>
</div>

<!-- Change Password Card -->

<!-- Enrollment Status Card -->
<div class="card" style="margin-top: 25px;">
    <div class="card-header">
        <h3 class="card-title">📋 Status Pendaftaran</h3>
    </div>
    <div class="card-body">
        <div id="enrollmentStatus">
            <p class="text-center text-muted">Memuatkan status...</p>
        </div>
    </div>
</div>