<?php
/**
 * Student Dashboard - Dashboard Tab Component
 * Displays: Welcome banner, stats, today's schedule, recent announcements
 */
?>

<!-- Welcome Banner -->
<div class="welcome-banner premium-gradient animate__animated animate__fadeIn"
    style="position: relative; overflow: hidden; padding: 40px; border-radius: var(--radius-xl); margin-bottom: 30px; color: white;">
    <div class="floating-bubbles">
        <div class="bubble" style="width: 40px; height: 40px; left: 10%; bottom: -10%; animation-delay: 0s;"></div>
        <div class="bubble" style="width: 20px; height: 20px; left: 30%; bottom: -10%; animation-delay: 2s;"></div>
        <div class="bubble" style="width: 60px; height: 60px; left: 50%; bottom: -10%; animation-delay: 4s;"></div>
        <div class="bubble" style="width: 30px; height: 30px; left: 70%; bottom: -10%; animation-delay: 1s;"></div>
        <div class="bubble" style="width: 50px; height: 50px; left: 90%; bottom: -10%; animation-delay: 3s;"></div>
    </div>
    <div class="reveal-up" style="position: relative; z-index: 2;">
        <h1 style="color: white; margin-bottom: 15px; font-size: 2.5rem;">Hai, <?php echo htmlspecialchars(explode(' ', $studentName)[0]); ?>! 👋</h1>
        <p style="font-size: 1.2rem; opacity: 0.9;">
            Anda ada <span id="classTodayCount" style="font-weight: 700; text-decoration: underline;">0</span> sesi kelas untuk bulan ini. 
            Jom belajar!
        </p>
        <div
            style="margin-top: 25px; font-weight: 500; background: rgba(255,255,255,0.15); padding: 10px 20px; border-radius: 30px; display: inline-block; backdrop-filter: blur(5px);">
            <span id="bannerDay">...</span>
        </div>
    </div>
</div>

<!-- Premium Stats Grid with Animations -->
<div class="stats-grid">
    <div class="stat-card" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); border-radius: 16px; padding: 25px; color: white; position: relative; overflow: hidden; cursor: pointer; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); animation: fadeInUp 0.6s ease-out 0.1s both;" onmouseover="this.style.transform='translateY(-8px) scale(1.02)'; this.style.boxShadow='0 20px 40px rgba(17,153,142,0.4)';" onmouseout="this.style.transform='translateY(0) scale(1)'; this.style.boxShadow='0 10px 30px rgba(0,0,0,0.1)';">
        <div style="position: absolute; top: -20px; right: -20px; font-size: 5rem; opacity: 0.2;">📚</div>
        <div style="position: relative; z-index: 1;">
            <div style="font-size: 3rem; font-weight: 800; text-shadow: 0 2px 10px rgba(0,0,0,0.2);"><?php echo count($studentSubjects); ?></div>
            <div style="font-size: 0.95rem; opacity: 0.95; font-weight: 500;">Jumlah Subjek</div>
        </div>
        <div style="position: absolute; bottom: 10px; right: 15px; background: rgba(255,255,255,0.2); padding: 5px 12px; border-radius: 20px; font-size: 0.75rem;">📖 Pelajaran</div>
    </div>
    <div class="stat-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 16px; padding: 25px; color: white; position: relative; overflow: hidden; cursor: pointer; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); animation: fadeInUp 0.6s ease-out 0.2s both;" onmouseover="this.style.transform='translateY(-8px) scale(1.02)'; this.style.boxShadow='0 20px 40px rgba(102,126,234,0.4)';" onmouseout="this.style.transform='translateY(0) scale(1)'; this.style.boxShadow='0 10px 30px rgba(0,0,0,0.1)';">
        <div style="position: absolute; top: -20px; right: -20px; font-size: 5rem; opacity: 0.2;">🎯</div>
        <div style="position: relative; z-index: 1;">
            <div style="font-size: 3rem; font-weight: 800; text-shadow: 0 2px 10px rgba(0,0,0,0.2);"><?php echo htmlspecialchars($studentLevel); ?></div>
            <div style="font-size: 0.95rem; opacity: 0.95; font-weight: 500;">Tahap Pendidikan</div>
        </div>
        <div style="position: absolute; bottom: 10px; right: 15px; background: rgba(255,255,255,0.2); padding: 5px 12px; border-radius: 20px; font-size: 0.75rem;">🎓 Pendidikan</div>
    </div>
    <div class="stat-card" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); border-radius: 16px; padding: 25px; color: white; position: relative; overflow: hidden; cursor: pointer; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); animation: fadeInUp 0.6s ease-out 0.3s both;" onmouseover="this.style.transform='translateY(-8px) scale(1.02)'; this.style.boxShadow='0 20px 40px rgba(240,147,251,0.4)';" onmouseout="this.style.transform='translateY(0) scale(1)'; this.style.boxShadow='0 10px 30px rgba(0,0,0,0.1)';">
        <div style="position: absolute; top: -20px; right: -20px; font-size: 5rem; opacity: 0.2;">📅</div>
        <div style="position: relative; z-index: 1;">
            <div style="font-size: 3rem; font-weight: 800; text-shadow: 0 2px 10px rgba(0,0,0,0.2);" id="upcomingClassesCount">0</div>
            <div style="font-size: 0.95rem; opacity: 0.95; font-weight: 500;">Kelas Akan Datang</div>
        </div>
        <div style="position: absolute; bottom: 10px; right: 15px; background: rgba(255,255,255,0.2); padding: 5px 12px; border-radius: 20px; font-size: 0.75rem;">⏰ Jadual</div>
    </div>
    <div class="stat-card" style="background: linear-gradient(135deg, #FF6B6B 0%, #FFE66D 100%); border-radius: 16px; padding: 25px; color: white; position: relative; overflow: hidden; cursor: pointer; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); animation: fadeInUp 0.6s ease-out 0.4s both;" onmouseover="this.style.transform='translateY(-8px) scale(1.02)'; this.style.boxShadow='0 20px 40px rgba(255,107,107,0.4)';" onmouseout="this.style.transform='translateY(0) scale(1)'; this.style.boxShadow='0 10px 30px rgba(0,0,0,0.1)';">
        <div style="position: absolute; top: -20px; right: -20px; font-size: 5rem; opacity: 0.2;">📖</div>
        <div style="position: relative; z-index: 1;">
            <div style="font-size: 3rem; font-weight: 800; text-shadow: 0 2px 10px rgba(0,0,0,0.2);" id="modulesCount">0</div>
            <div style="font-size: 0.95rem; opacity: 0.95; font-weight: 500;">Modul Tersedia</div>
        </div>
        <div style="position: absolute; bottom: 10px; right: 15px; background: rgba(255,255,255,0.2); padding: 5px 12px; border-radius: 20px; font-size: 0.75rem;">📚 Modul</div>
    </div>
</div>

<!-- Dashboard Widgets Grid -->
<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 15px; margin-top: 15px;">
    <!-- Today's Schedule Widget -->
    <div class="card animate__animated animate__fadeInLeft">
        <div class="card-header">
            <h3 class="card-title">📅 Jadual Bulan Ini</h3>
            <a href="#" onclick="switchTab(event, 'schedule')" class="btn btn-sm btn-primary">Lihat Semua</a>
        </div>
        <div class="card-body" id="todayScheduleWidget">
            <p class="text-center text-muted">Memuatkan...</p>
        </div>
    </div>
    
    <!-- Recent Announcements Widget -->
    <div class="card animate__animated animate__fadeInRight">
        <div class="card-header">
            <h3 class="card-title">📢 Pengumuman Terkini</h3>
            <a href="#" onclick="switchTab(event, 'announcements')" class="btn btn-sm btn-primary">Lihat Semua</a>
        </div>
        <div class="card-body" id="recentAnnouncementsWidget">
            <p class="text-center text-muted">Memuatkan...</p>
        </div>
    </div>
    
    <!-- My Info Card -->
    <div class="card animate__animated animate__fadeInUp">
        <div class="card-header">
            <h3 class="card-title">📋 Maklumat Saya</h3>
        </div>
        <div class="card-body">
            <div class="info-row">
                <span class="info-label">Nama Penuh</span>
                <span class="info-value"><?php echo htmlspecialchars($studentName); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Umur</span>
                <span class="info-value"><?php echo htmlspecialchars($studentAge); ?> tahun</span>
            </div>
            <div class="info-row">
                <span class="info-label">Tahap</span>
                <span class="info-value"><?php echo htmlspecialchars($studentLevel); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Tahun/Tingkatan</span>
                <span class="info-value"><?php echo htmlspecialchars($studentGrade); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Nama Pengguna</span>
                <span class="info-value">@<?php echo htmlspecialchars($student['username'] ?? '-'); ?></span>
            </div>
        </div>
    </div>
    
    <!-- My Subjects Card -->
    <div class="card animate__animated animate__fadeInUp" style="animation-delay: 0.1s;">
        <div class="card-header">
            <h3 class="card-title">📚 Subjek Saya</h3>
        </div>
        <div class="card-body">
            <?php if (!empty($studentSubjects)): ?>
                <div style="display: flex; flex-wrap: wrap; gap: 10px;">
                    <?php foreach ($studentSubjects as $subject): ?>
                        <span class="subject-tag"><?php echo htmlspecialchars($subject); ?></span>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <p class="text-muted text-center">Tiada subjek didaftarkan</p>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Contacts Card -->
    <div class="card animate__animated animate__fadeInUp" style="animation-delay: 0.2s;">
        <div class="card-header">
            <h3 class="card-title">👨‍🏫 Kontak Mentor & Guru</h3>
        </div>
        <div class="card-body" id="studentContactsWidget">
            <p class="text-center text-muted">Memuatkan...</p>
        </div>
    </div>
</div>
