<?php
require_once __DIR__ . '/db.php';

try {
    echo "Checking 'students' table schema...\n";

    // Check if table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'students'");
    if (!$stmt->fetch()) {
        echo "Table 'students' does not exist!\n";
        // Create it? (Simplified)
        $sql = "CREATE TABLE `students` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `username` varchar(50) NOT NULL,
          `password` varchar(255) DEFAULT NULL,
          `full_name` varchar(100) NOT NULL,
          `age` int(11) NOT NULL,
          `parent_guardian_name` varchar(100) NOT NULL,
          `phone` varchar(20) NOT NULL,
          `education_level` varchar(50) NOT NULL,
          `grade_level` varchar(50) NOT NULL,
          `required_subjects` text NOT NULL,
          `profile_emoji` varchar(50) DEFAULT '👨‍🎓',
          `status` enum('Active','Inactive','Pending') DEFAULT 'Pending',
          `enrolled_by` int(11) DEFAULT NULL,
          `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
          PRIMARY KEY (`id`),
          UNIQUE KEY `username` (`username`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
        $pdo->exec($sql);
        echo "Table 'students' created.\n";
    } else {
        // Check enrolled_by
        $stmt = $pdo->query("SHOW COLUMNS FROM students LIKE 'enrolled_by'");
        if (!$stmt->fetch()) {
            $pdo->exec("ALTER TABLE students ADD COLUMN enrolled_by INT(11) DEFAULT NULL AFTER status");
            echo "Column 'enrolled_by' added to students table.\n";
        } else {
            echo "Column 'enrolled_by' exists.\n";
        }
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
