<?php
// fix_db.php
$dbPath = __DIR__ . '/db.php';
if (file_exists($dbPath)) {
    require_once $dbPath;
} else {
    die(json_encode(['success' => false, 'message' => 'Ralat: Fail db.php tidak dijumpai di ' . $dbPath]));
}

header('Content-Type: application/json');

try {
    // 1. Allow teacher_id to be NULL in announcements
    $sql1 = "ALTER TABLE announcements MODIFY teacher_id INT(11) NULL";
    $pdo->exec($sql1);

    // 2. Add created_by column if not exists
    $stmt = $pdo->query("SHOW COLUMNS FROM announcements LIKE 'created_by'");
    if ($stmt->rowCount() == 0) {
        $sql2 = "ALTER TABLE announcements ADD COLUMN created_by INT(11) NULL AFTER teacher_id";
        $pdo->exec($sql2);
    }

    echo json_encode(['success' => true, 'message' => 'Database fixed successfully']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>