<?php
/**
 * Teacher Dashboard - Tab OPR (One Page Report)
 * Info dan pautan dokumentasi OPR
 */

$oprInfo = null;

// Get OPR info from settings
try {
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'opr_info'");
    $stmt->execute();
    $oprData = $stmt->fetch();

    if ($oprData && $oprData['setting_value']) {
        $oprInfo = json_decode($oprData['setting_value'], true);
    }
} catch (Exception $e) {
    $oprInfo = null;
}

$defaultOprInfo = [
    'title' => 'One Page Report (OPR)',
    'description' => 'One Page Report merupakan satu dokumentasi ringkas yang menerangkan penggunaan One Page Report sebagai medium pelaporan utama dalam pengurusan. Dokumentasi ini bertujuan untuk merekod dan memaparkan maklumat penting seperti prestasi pembelajaran, tahap pencapaian pelajar dalam satu paparan yang padat dan mudah difahami. Penggunaan OPR membantu guru memantau perkembangan pelajar secara sistematik, memudahkan komunikasi dengan ibu bapa, serta menyokong perancangan pengajaran yang lebih berfokus dan berasaskan data.',
    'link' => 'https://www.canva.com/design/DAG6y7UmBKU/view'
];

$oprInfo = $oprInfo ?: $defaultOprInfo;
?>
<!-- Tab OPR -->
<div id="opr" class="tab-content <?php echo $currentTab === 'opr' ? 'active' : ''; ?>">
    <!-- Header Card -->
    <div class="card"
        style="margin-bottom: 25px; border-radius: 20px; overflow: hidden; border: none; box-shadow: 0 10px 40px rgba(0,0,0,0.05); animation: fadeInDown 0.6s ease-out;">
        <div style="height: 6px; background: linear-gradient(90deg, var(--primary-color) 0%, #764ba2 100%);"></div>
        <div class="card-body" style="padding: 25px;">
            <div style="display: flex; align-items: center; gap: 20px; flex-wrap: wrap;">
                <div
                    style="background: linear-gradient(135deg, var(--primary-color) 0%, #764ba2 100%); width: 60px; height: 60px; border-radius: 16px; display: flex; align-items: center; justify-content: center; font-size: 1.8rem; box-shadow: 0 8px 16px rgba(102, 126, 234, 0.25); color: white;">
                    📄
                </div>
                <div style="flex: 1; min-width: 200px;">
                    <h4 style="margin: 0 0 5px 0; color: #1a1a2e; font-size: 1.4rem; font-weight: 800;">One Page Report
                        (OPR)</h4>
                    <p style="margin: 0; color: #6b7280; font-size: 0.95rem; line-height: 1.5;">Dokumentasi & Panduan
                        Penggunaan sistem pelaporan Tuisyen Kita.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Content Card -->
    <div class="card"
        style="border-radius: 20px; border: none; box-shadow: 0 10px 40px rgba(0,0,0,0.05); overflow: hidden; animation: fadeInUp 0.6s ease-out 0.2s both;">
        <div class="card-header bg-white"
            style="padding: 20px 25px; border-bottom: 1px solid #f0f0f0; display: flex; justify-content: space-between; align-items: center;">
            <div style="display: flex; align-items: center; gap: 12px;">
                <div
                    style="background: #f0f4ff; width: 35px; height: 35px; border-radius: 10px; display: flex; align-items: center; justify-content: center; color: var(--primary-color);">
                    <i class="fas fa-info-circle"></i>
                </div>
                <h3 class="card-title" style="margin: 0; font-size: 1.15rem; font-weight: 700; color: #1a1a2e;">Maklumat
                    OPR</h3>
            </div>
            <a href="<?php echo htmlspecialchars($oprInfo['link']); ?>" target="_blank"
                class="btn btn-primary btn-sm rounded-pill px-4 py-2 shadow-sm d-flex align-items-center gap-2"
                style="background: linear-gradient(135deg, var(--primary-color) 0%, #764ba2 100%); border: none; font-weight: 600; transition: transform 0.2s;">
                <span>🔗</span> Buka Dokumen
            </a>
        </div>
        <div class="card-body" style="padding: 30px;">
            <div class="row">
                <div class="col-md-8">
                    <h5 style="color: #1a1a2e; font-weight: 700; margin-bottom: 15px;">Penerangan</h5>
                    <div class="description-box"
                        style="background: #f8f9fa; padding: 25px; border-radius: 16px; line-height: 1.8; margin-bottom: 30px; border-left: 5px solid var(--primary-color);">
                        <?php echo nl2br(htmlspecialchars($oprInfo['description'])); ?>
                    </div>

                    <h5 style="color: #1a1a2e; font-weight: 700; margin-bottom: 20px;">Faedah Penggunaan OPR</h5>
                    <div
                        style="display: grid; grid-template-columns: repeat(auto-fill, minmax(250px, 1fr)); gap: 15px;">
                        <div class="benefit-item"
                            style="display: flex; align-items: center; gap: 15px; padding: 15px; background: white; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.03); border: 1px solid #f0f0f0; transition: transform 0.2s;">
                            <span style="font-size: 1.5rem;">📊</span>
                            <span style="font-weight: 500; color: #4b5563;">Paparan padat & mudah</span>
                        </div>
                        <div class="benefit-item"
                            style="display: flex; align-items: center; gap: 15px; padding: 15px; background: white; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.03); border: 1px solid #f0f0f0; transition: transform 0.2s;">
                            <span style="font-size: 1.5rem;">📈</span>
                            <span style="font-weight: 500; color: #4b5563;">Pemantauan sistematik</span>
                        </div>
                        <div class="benefit-item"
                            style="display: flex; align-items: center; gap: 15px; padding: 15px; background: white; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.03); border: 1px solid #f0f0f0; transition: transform 0.2s;">
                            <span style="font-size: 1.5rem;">👨‍👩‍👧</span>
                            <span style="font-weight: 500; color: #4b5563;">Komunikasi efektif</span>
                        </div>
                        <div class="benefit-item"
                            style="display: flex; align-items: center; gap: 15px; padding: 15px; background: white; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.03); border: 1px solid #f0f0f0; transition: transform 0.2s;">
                            <span style="font-size: 1.5rem;">📅</span>
                            <span style="font-weight: 500; color: #4b5563;">Perancangan data</span>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mt-4 mt-md-0">
                    <div class="card bg-light border-0" style="border-radius: 16px;">
                        <div class="card-body text-center p-4">
                            <div style="font-size: 4rem; margin-bottom: 15px;">📘</div>
                            <h5 style="margin-bottom: 10px; font-weight: 700;">Dokumentasi Lengkap</h5>
                            <p class="text-muted small mb-4">Klik butang di bawah untuk akses penuh dokumen OPR.</p>
                            <a href="<?php echo htmlspecialchars($oprInfo['link']); ?>" target="_blank"
                                class="btn btn-outline-primary btn-block rounded-pill" style="font-weight: 600;">Lihat
                                Sekarang ➔</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>