<?php
/**
 * Student Dashboard - Classes Tab Component
 * Displays: Online classes (upcoming/past), join buttons, recordings
 */
?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">🏫 Kelas Online Saya</h3>
        <div style="display: flex; gap: 10px;">
            <select class="form-control form-select" id="classStatusFilter" onchange="filterClasses()" style="width: auto;">
                <option value="upcoming">Akan Datang</option>
                <option value="past">Lepas</option>
                <option value="all">Semua</option>
            </select>
            <select class="form-control form-select" id="classSubjectFilter" onchange="filterClasses()" style="width: auto;">
                <option value="all">Semua Subjek</option>
                <?php foreach ($studentSubjects as $subject): ?>
                    <option value="<?php echo htmlspecialchars($subject); ?>"><?php echo htmlspecialchars($subject); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <div class="card-body">
        <!-- Upcoming Classes Section -->
        <div id="upcomingClassesSection" style="margin-bottom: 30px;">
            <h4 style="color: var(--primary-color); margin-bottom: 15px;">📅 Kelas Akan Datang</h4>
            <div id="upcomingClassesList">
                <p class="text-center text-muted">Memuatkan...</p>
            </div>
        </div>
        
        <!-- Past Classes Section -->
        <div id="pastClassesSection">
            <h4 style="color: #666; margin-bottom: 15px;">📚 Kelas Lepas</h4>
            <div id="pastClassesList">
                <p class="text-center text-muted">Memuatkan...</p>
            </div>
        </div>
    </div>
</div>
